<x-app-layout>
    <x-slot name="header">
        <h2 class="font-bold text-3xl text-gray-800 dark:text-gray-100 leading-tight">
            {{ __('Daftar Barang Tersedia') }}
        </h2>
    </x-slot>

    <div class="py-8 lg:py-12 bg-gray-100 dark:bg-gray-900 min-h-screen">
        {{-- DIUBAH: w-full untuk lebar penuh, px-4 sm:px-6 lg:px-8 untuk padding --}}
        <div class="w-full px-4 sm:px-6 lg:px-8">
            <div class="bg-white dark:bg-gray-800 overflow-hidden shadow-2xl sm:rounded-xl p-6 lg:p-8 border border-gray-200 dark:border-gray-700">
                <h3 class="text-2xl font-extrabold text-gray-900 dark:text-gray-100 mb-6 border-b pb-4 border-gray-200 dark:border-gray-700">{{ __('Lihat Barang yang Bisa Dipinjam') }}</h3>

                @if (session('success'))
                    <div class="bg-green-100 dark:bg-green-800 border border-green-400 text-green-700 dark:text-green-200 px-4 py-3 rounded relative mb-6 shadow-md" role="alert">
                        <span class="block sm:inline font-medium"><i class="fas fa-check-circle mr-2"></i> {{ session('success') }}</span>
                    </div>
                @endif
                @if (session('error'))
                    <div class="bg-red-100 dark:bg-red-800 border border-red-400 text-red-700 dark:text-red-200 px-4 py-3 rounded relative mb-6 shadow-md" role="alert">
                        <span class="block sm:inline font-medium"><i class="fas fa-exclamation-triangle mr-2"></i> {{ session('error') }}</span>
                    </div>
                @endif

                <div class="overflow-x-auto bg-gray-50 dark:bg-gray-700 rounded-xl shadow-lg border border-gray-200 dark:border-gray-600">
                    <table class="min-w-full divide-y divide-gray-200 dark:divide-gray-600">
                        <thead class="bg-gray-100 dark:bg-gray-700">
                            <tr>
                                <th scope="col" class="px-6 py-4 text-left text-xs font-semibold text-gray-700 dark:text-gray-300 uppercase tracking-wider">
                                    Nama Barang
                                </th>
                                <th scope="col" class="px-6 py-4 text-left text-xs font-semibold text-gray-700 dark:text-gray-300 uppercase tracking-wider">
                                    Kode
                                </th>
                                <th scope="col" class="px-6 py-4 text-left text-xs font-semibold text-gray-700 dark:text-gray-300 uppercase tracking-wider">
                                    Deskripsi
                                </th>
                                <th scope="col" class="px-6 py-4 text-left text-xs font-semibold text-gray-700 dark:text-gray-300 uppercase tracking-wider">
                                    Stok Tersedia
                                </th>
                                <th scope="col" class="px-6 py-4 text-right text-xs font-semibold text-gray-700 dark:text-gray-300 uppercase tracking-wider">
                                    Aksi
                                </th>
                            </tr>
                        </thead>
                        <tbody class="bg-white dark:bg-gray-800 divide-y divide-gray-200 dark:divide-gray-700">
                            @forelse ($items as $item)
                                <tr class="hover:bg-gray-50 dark:hover:bg-gray-700 transition-colors duration-200">
                                    <td class="px-6 py-4 whitespace-nowrap text-base font-medium text-gray-900 dark:text-gray-100">
                                        {{ $item->name }}
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap text-base text-gray-600 dark:text-gray-300">
                                        {{ $item->code }}
                                    </td>
                                    <td class="px-6 py-4 text-base text-gray-600 dark:text-gray-300 max-w-xs truncate">
                                        {{ $item->description ?? '-' }}
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap text-base text-gray-600 dark:text-gray-300">
                                        <span class="px-3 py-1 inline-flex text-sm leading-5 font-semibold rounded-full
                                            @if ($item->quantity > 0) bg-green-100 text-green-800 dark:bg-green-700 dark:text-green-100
                                            @else bg-red-100 text-red-800 dark:bg-red-700 dark:text-red-100 @endif">
                                            {{ $item->quantity }}
                                        </span>
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap text-right text-base font-medium">
                                        @if ($item->quantity > 0)
                                            <a href="{{ route('user.borrowings.create', ['item_id' => $item->id]) }}" class="inline-flex items-center px-6 py-3 bg-blue-600 border border-transparent rounded-lg font-semibold text-sm text-white uppercase tracking-wider hover:bg-blue-700 focus:bg-blue-700 active:bg-blue-900 focus:outline-none focus:ring-2 focus:ring-indigo-500 focus:ring-offset-2 dark:focus:ring-offset-gray-800 transition ease-in-out duration-150 shadow-md">
                                                <i class="fas fa-hand-holding-box mr-2"></i> {{ __('Pinjam') }}
                                            </a>
                                        @else
                                            <span class="px-3 py-1 text-base font-normal text-gray-500 dark:text-gray-400 bg-gray-100 dark:bg-gray-700 rounded-md">Stok Habis</span>
                                        @endif
                                    </td>
                                </tr>
                            @empty
                                <tr>
                                    <td colspan="5" class="px-6 py-4 text-center text-base text-gray-600 dark:text-gray-300">
                                        <i class="fas fa-box-open mr-2"></i> Tidak ada barang yang tersedia untuk dipinjam saat ini.
                                    </td>
                                </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</x-app-layout>