<x-app-layout>
    <x-slot name="header">
        <h2 class="font-bold text-3xl text-gray-800 dark:text-gray-100 leading-tight">
            {{ __('User Dashboard') }}
        </h2>
    </x-slot>

    <div class="py-8 lg:py-12 bg-gray-100 dark:bg-gray-900 min-h-screen">
        {{-- DIUBAH: w-full untuk lebar penuh, px-4 sm:px-6 lg:px-8 untuk padding --}}
        <div class="w-full px-4 sm:px-6 lg:px-8">
            <div class="bg-white dark:bg-gray-800 overflow-hidden shadow-2xl sm:rounded-xl p-6 lg:p-8 border border-gray-200 dark:border-gray-700">
                <h3 class="text-2xl font-extrabold text-gray-900 dark:text-gray-100 mb-8 border-b pb-4 border-gray-200 dark:border-gray-700">Informasi Peminjaman Anda</h3>

                <div class="grid grid-cols-1 md:grid-cols-3 gap-6 mb-12">
                    {{-- Card Barang Tersedia --}}
                    <div class="bg-gradient-to-br from-indigo-600 to-indigo-800 dark:from-indigo-800 dark:to-indigo-950 text-white p-6 rounded-xl shadow-lg flex items-center space-x-4 transform transition duration-300 hover:scale-105 hover:shadow-xl">
                        <div class="p-4 bg-indigo-900 dark:bg-indigo-700 rounded-full flex-shrink-0">
                            <i class="fas fa-boxes text-3xl"></i>
                        </div>
                        <div>
                            <p class="text-sm font-light opacity-90 mb-1">{{ __('Barang Tersedia') }}</p>
                            <p class="text-5xl font-extrabold">{{ $availableItems }}</p>
                        </div>
                    </div>

                    {{-- Card Peminjaman Tertunda --}}
                    <div class="bg-gradient-to-br from-amber-600 to-amber-800 dark:from-amber-800 dark:to-amber-950 text-white p-6 rounded-xl shadow-lg flex items-center space-x-4 transform transition duration-300 hover:scale-105 hover:shadow-xl">
                        <div class="p-4 bg-amber-900 dark:bg-amber-700 rounded-full flex-shrink-0">
                            <i class="fas fa-clock text-3xl"></i>
                        </div>
                        <div>
                            <p class="text-sm font-light opacity-90 mb-1">{{ __('Peminjaman Tertunda') }}</p>
                            <p class="text-5xl font-extrabold">{{ $myPendingBorrowings }}</p>
                        </div>
                    </div>

                    {{-- Card Peminjaman Disetujui --}}
                    <div class="bg-gradient-to-br from-green-600 to-green-800 dark:from-green-800 dark:to-green-950 text-white p-6 rounded-xl shadow-lg flex items-center space-x-4 transform transition duration-300 hover:scale-105 hover:shadow-xl">
                        <div class="p-4 bg-green-900 dark:bg-green-700 rounded-full flex-shrink-0">
                            <i class="fas fa-check-double text-3xl"></i>
                        </div>
                        <div>
                            <p class="text-sm font-light opacity-90 mb-1">{{ __('Peminjaman Disetujui') }}</p>
                            <p class="text-5xl font-extrabold">{{ $myApprovedBorrowings }}</p>
                        </div>
                    </div>
                </div>

                <h3 class="text-2xl font-extrabold text-gray-900 dark:text-gray-100 mb-6 border-b pb-4 border-gray-200 dark:border-gray-700">Aksi Cepat</h3>
                <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
                    <a href="{{ route('user.items.index') }}" class="group flex items-center p-6 bg-gray-50 dark:bg-gray-700 rounded-xl shadow-md hover:shadow-lg transition-all duration-300 transform hover:-translate-y-2 border border-gray-200 dark:border-gray-600">
                        <div class="p-4 bg-blue-500 dark:bg-blue-600 text-white rounded-full mr-4 group-hover:bg-blue-700 dark:group-hover:bg-blue-800 transition-colors">
                            <i class="fas fa-clipboard-list text-2xl"></i>
                        </div>
                        <div>
                            <p class="text-xl font-bold text-gray-800 dark:text-gray-100 group-hover:text-blue-700 dark:group-hover:text-blue-200 transition-colors">{{ __('Lihat Daftar Barang') }}</p>
                            <p class="text-sm text-gray-600 dark:text-gray-300 mt-1">Cari dan lihat barang yang tersedia untuk dipinjam.</p>
                        </div>
                    </a>

                    <a href="{{ route('user.borrowings.create') }}" class="group flex items-center p-6 bg-gray-50 dark:bg-gray-700 rounded-xl shadow-md hover:shadow-lg transition-all duration-300 transform hover:-translate-y-2 border border-gray-200 dark:border-gray-600">
                        <div class="p-4 bg-green-500 dark:bg-green-600 text-white rounded-full mr-4 group-hover:bg-green-700 dark:group-hover:bg-green-800 transition-colors">
                            <i class="fas fa-hand-holding text-2xl"></i>
                        </div>
                        <div>
                            <p class="text-xl font-bold text-gray-800 dark:text-gray-100 group-hover:text-green-700 dark:group-hover:text-green-200 transition-colors">{{ __('Ajukan Peminjaman Baru') }}</p>
                            <p class="text-sm text-gray-600 dark:text-gray-300 mt-1">Ajukan permintaan pinjam barang.</p>
                        </div>
                    </a>

                    <a href="{{ route('user.my-borrowings.index') }}" class="group flex items-center p-6 bg-gray-50 dark:bg-gray-700 rounded-xl shadow-md hover:shadow-lg transition-all duration-300 transform hover:-translate-y-2 border border-gray-200 dark:border-gray-600">
                        <div class="p-4 bg-purple-500 dark:bg-purple-600 text-white rounded-full mr-4 group-hover:bg-purple-700 dark:group-hover:bg-purple-800 transition-colors">
                            <i class="fas fa-book-reader text-2xl"></i>
                        </div>
                        <div>
                            <p class="text-xl font-bold text-gray-800 dark:text-gray-100 group-hover:text-purple-700 dark:group-hover:text-purple-200 transition-colors">{{ __('Riwayat Peminjaman Saya') }}</p>
                            <p class="text-sm text-gray-600 dark:text-gray-300 mt-1">Lihat status dan riwayat peminjaman Anda.</p>
                        </div>
                    </a>
                </div>
            </div>
        </div>
    </div>
</x-app-layout>