<x-app-layout>
    <x-slot name="header">
        <h2 class="font-bold text-3xl text-gray-800 dark:text-gray-100 leading-tight">
            {{ __('Riwayat Peminjaman Saya') }}
        </h2>
    </x-slot>

    <div class="py-8 lg:py-12 bg-gray-100 dark:bg-gray-900 min-h-screen">
        {{-- DIUBAH: w-full untuk lebar penuh, px-4 sm:px-6 lg:px-8 untuk padding --}}
        <div class="w-full px-4 sm:px-6 lg:px-8">
            <div class="bg-white dark:bg-gray-800 overflow-hidden shadow-2xl sm:rounded-xl p-6 lg:p-8 border border-gray-200 dark:border-gray-700">
                <h3 class="text-2xl font-extrabold text-gray-900 dark:text-gray-100 mb-6 border-b pb-4 border-gray-200 dark:border-gray-700">{{ __('Daftar Peminjaman Anda') }}</h3>

                @if (session('success'))
                    <div class="bg-green-100 dark:bg-green-800 border border-green-400 text-green-700 dark:text-green-200 px-4 py-3 rounded relative mb-6 shadow-md" role="alert">
                        <span class="block sm:inline font-medium"><i class="fas fa-check-circle mr-2"></i> {{ session('success') }}</span>
                    </div>
                @endif
                @if (session('error'))
                    <div class="bg-red-100 dark:bg-red-800 border border-red-400 text-red-700 dark:text-red-200 px-4 py-3 rounded relative mb-6 shadow-md" role="alert">
                        <span class="block sm:inline font-medium"><i class="fas fa-exclamation-triangle mr-2"></i> {{ session('error') }}</span>
                    </div>
                @endif

                <div class="overflow-x-auto bg-gray-50 dark:bg-gray-700 rounded-xl shadow-lg border border-gray-200 dark:border-gray-600">
                    <table class="min-w-full divide-y divide-gray-200 dark:divide-gray-600">
                        <thead class="bg-gray-100 dark:bg-gray-700">
                            <tr>
                                <th scope="col" class="px-6 py-4 text-left text-xs font-semibold text-gray-700 dark:text-gray-300 uppercase tracking-wider">
                                    Barang
                                </th>
                                <th scope="col" class="px-6 py-4 text-left text-xs font-semibold text-gray-700 dark:text-gray-300 uppercase tracking-wider">
                                    Jumlah
                                </th>
                                <th scope="col" class="px-6 py-4 text-left text-xs font-semibold text-gray-700 dark:text-gray-300 uppercase tracking-wider">
                                    Tgl & Jam Pinjam
                                </th>
                                <th scope="col" class="px-6 py-4 text-left text-xs font-semibold text-gray-700 dark:text-gray-300 uppercase tracking-wider">
                                    Tgl & Jam Kembali
                                </th>
                                <th scope="col" class="px-6 py-4 text-left text-xs font-semibold text-gray-700 dark:text-gray-300 uppercase tracking-wider">
                                    Status
                                </th>
                                <th scope="col" class="px-6 py-4 text-left text-xs font-semibold text-gray-700 dark:text-gray-300 uppercase tracking-wider">
                                    Catatan
                                </th>
                            </tr>
                        </thead>
                        <tbody class="bg-white dark:bg-gray-800 divide-y divide-gray-200 dark:divide-gray-700">
                            @forelse ($myBorrowings as $borrowing)
                                <tr class="hover:bg-gray-50 dark:hover:bg-gray-700 transition-colors duration-200">
                                    <td class="px-6 py-4 whitespace-nowrap text-base font-medium text-gray-900 dark:text-gray-100">
                                        {{ $borrowing->item->name }} ({{ $borrowing->item->code }})
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap text-base text-gray-600 dark:text-gray-300">
                                        {{ $borrowing->quantity }}
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap text-base text-gray-600 dark:text-gray-300">
                                        {{ \Carbon\Carbon::parse($borrowing->borrow_date . ' ' . $borrowing->borrow_time)->format('d M Y, H:i') }} WIB
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap text-base text-gray-600 dark:text-gray-300">
                                        @if($borrowing->return_date && $borrowing->return_time)
                                            {{ \Carbon\Carbon::parse($borrowing->return_date . ' ' . $borrowing->return_time)->format('d M Y, H:i') }} WIB
                                        @else
                                            -
                                        @endif
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap text-base">
                                        <span class="px-3 py-1 inline-flex text-sm leading-5 font-semibold rounded-full
                                            @if ($borrowing->status == 'pending') bg-yellow-100 text-yellow-800 dark:bg-yellow-700 dark:text-yellow-100
                                            @elseif ($borrowing->status == 'approved') bg-blue-100 text-blue-800 dark:bg-blue-700 dark:text-blue-100
                                            @elseif ($borrowing->status == 'rejected') bg-red-100 text-red-800 dark:bg-red-700 dark:text-red-100
                                            @elseif ($borrowing->status == 'returned') bg-green-100 text-green-800 dark:bg-green-700 dark:text-green-100
                                            @elseif ($borrowing->status == 'overdue') bg-orange-100 text-orange-800 dark:bg-orange-700 dark:text-orange-100
                                            @else bg-gray-100 text-gray-800 dark:bg-gray-600 dark:text-gray-200 @endif">
                                            {{ ucfirst($borrowing->status) }}
                                        </span>
                                    </td>
                                    <td class="px-6 py-4 text-base text-gray-600 dark:text-gray-300 max-w-xs truncate" title="{{ $borrowing->notes }}">
                                        {{ $borrowing->notes ?? '-' }}
                                    </td>
                                </tr>
                            @empty
                                <tr>
                                    <td colspan="6" class="px-6 py-4 text-center text-base text-gray-600 dark:text-gray-300">
                                        <i class="fas fa-info-circle mr-2"></i> Anda belum memiliki riwayat peminjaman. Ajukan <a href="{{ route('user.borrowings.create') }}" class="text-blue-600 dark:text-blue-400 hover:underline font-medium">peminjaman pertama Anda</a>!
                                    </td>
                                </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</x-app-layout>