<nav x-data="{ open: false }" class="bg-white dark:bg-gray-800 border-b border-gray-100 dark:border-gray-700 shadow-sm">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="flex justify-between h-16">
            <div class="flex">
                <div class="shrink-0 flex items-center">
                    <a href="{{ url('/') }}">
                        {{-- Sesuaikan path logo atau gunakan teks saja jika belum ada --}}
                        <x-application-logo class="block h-9 w-auto fill-current text-gray-800 dark:text-gray-200" />
                        {{-- Atau teks logo sederhana: --}}
                        {{-- <span class="text-2xl font-bold text-gray-800 dark:text-gray-200">LabTJKT</span> --}}
                    </a>
                </div>

                <div class="hidden space-x-8 sm:-my-px sm:ms-10 sm:flex">
                    @auth
                        @if (auth()->user()->isAdmin())
                            <x-nav-link :href="route('admin.dashboard')" :active="request()->routeIs('admin.dashboard')">
                                <i class="fas fa-tachometer-alt mr-2"></i> {{ __('Admin Dashboard') }}
                            </x-nav-link>
                            <x-nav-link :href="route('admin.items.index')" :active="request()->routeIs('admin.items.*')">
                                <i class="fas fa-boxes mr-2"></i> {{ __('Kelola Barang') }}
                            </x-nav-link>
                            {{-- --- BARIS INI DITAMBAHKAN UNTUK LINK INVENTARIS (DESKTOP) --- --}}
                            <x-nav-link :href="route('admin.inventories.index')" :active="request()->routeIs('admin.inventories.*')">
                                <i class="fas fa-warehouse mr-2"></i> {{ __('Inventaris') }}
                            </x-nav-link>
                            {{-- ----------------------------------------------------------- --}}
                            <x-nav-link :href="route('admin.borrowings.index')" :active="request()->routeIs('admin.borrowings.*')">
                                <i class="fas fa-handshake mr-2"></i> {{ __('Monitoring Peminjaman') }}
                            </x-nav-link>
                            <x-nav-link :href="route('admin.reports.daily')" :active="request()->routeIs('admin.reports.daily')">
                                <i class="fas fa-chart-line mr-2"></i> {{ __('Laporan Harian') }}
                            </x-nav-link>
                            {{-- Tambahkan link admin lainnya di sini jika diperlukan --}}
                        @else
                            <x-nav-link :href="route('user.dashboard')" :active="request()->routeIs('user.dashboard')">
                                <i class="fas fa-home mr-2"></i> {{ __('User Dashboard') }}
                            </x-nav-link>
                            <x-nav-link :href="route('user.items.index')" :active="request()->routeIs('user.items.*')">
                                <i class="fas fa-list-alt mr-2"></i> {{ __('Daftar Barang') }}
                            </x-nav-link>
                            <x-nav-link :href="route('user.borrowings.create')" :active="request()->routeIs('user.borrowings.create')">
                                <i class="fas fa-plus-circle mr-2"></i> {{ __('Ajukan Peminjaman') }}
                            </x-nav-link>
                            <x-nav-link :href="route('user.my-borrowings.index')" :active="request()->routeIs('user.my-borrowings.*')">
                                <i class="fas fa-history mr-2"></i> {{ __('Peminjaman Saya') }}
                            </x-nav-link>
                        @endif
                    @endauth
                </div>
            </div>

            <div class="hidden sm:flex sm:items-center sm:ms-6">
                <x-dropdown align="right" width="48">
                    <x-slot name="trigger">
                        <button class="inline-flex items-center px-3 py-2 border border-transparent text-sm leading-4 font-medium rounded-md text-gray-500 dark:text-gray-400 bg-white dark:bg-gray-800 hover:text-gray-700 dark:hover:text-gray-300 focus:outline-none transition ease-in-out duration-150">
                            <div>{{ Auth::user()->name }}</div>

                            <div class="ms-1">
                                <svg class="fill-current h-4 w-4" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20">
                                    <path fill-rule="evenodd" d="M5.293 7.293a1 1 0 011.414 0L10 10.586l3.293-3.293a1 1 0 111.414 1.414l-4 4a1 1 0 01-1.414 0l-4-4a1 1 0 010-1.414z" clip-rule="evenodd" />
                                </svg>
                            </div>
                        </button>
                    </x-slot>

                    <x-slot name="content">
                        <x-dropdown-link :href="route('profile.edit')">
                            <i class="fas fa-user-circle mr-2"></i> {{ __('Profil') }}
                        </x-dropdown-link>

                        <form method="POST" action="{{ route('logout') }}">
                            @csrf
                            <x-dropdown-link :href="route('logout')"
                                    onclick="event.preventDefault();
                                                this.closest('form').submit();">
                                <i class="fas fa-sign-out-alt mr-2"></i> {{ __('Log Out') }}
                            </x-dropdown-link>
                        </form>
                    </x-slot>
                </x-dropdown>
            </div>

            <div class="-me-2 flex items-center sm:hidden">
                <button @click="open = ! open" class="inline-flex items-center justify-center p-2 rounded-md text-gray-400 dark:text-gray-500 hover:text-gray-500 dark:hover:text-gray-400 hover:bg-gray-100 dark:hover:bg-gray-900 focus:outline-none focus:bg-gray-100 dark:focus:bg-gray-900 focus:text-gray-500 dark:focus:text-gray-400 transition duration-150 ease-in-out">
                    <svg class="h-6 w-6" stroke="currentColor" fill="none" viewBox="0 0 24 24">
                        <path :class="{'hidden': open, 'inline-flex': ! open }" class="inline-flex" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6h16M4 12h16M4 18h16" />
                        <path :class="{'hidden': ! open, 'inline-flex': open }" class="hidden" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12" />
                    </svg>
                </button>
            </div>
        </div>
    </div>

    <div :class="{'block': open, 'hidden': ! open}" class="hidden sm:hidden">
        <div class="pt-2 pb-3 space-y-1">
            @auth
                @if (auth()->user()->isAdmin())
                    <x-responsive-nav-link :href="route('admin.dashboard')" :active="request()->routeIs('admin.dashboard')">
                        <i class="fas fa-tachometer-alt mr-2"></i> {{ __('Admin Dashboard') }}
                    </x-responsive-nav-link>
                    <x-responsive-nav-link :href="route('admin.items.index')" :active="request()->routeIs('admin.items.*')">
                        <i class="fas fa-boxes mr-2"></i> {{ __('Kelola Barang') }}
                    </x-responsive-nav-link>
                    {{-- --- BARIS INI DITAMBAHKAN UNTUK LINK INVENTARIS (RESPONSIF) --- --}}
                    <x-responsive-nav-link :href="route('admin.inventories.index')" :active="request()->routeIs('admin.inventories.*')">
                        <i class="fas fa-warehouse mr-2"></i> {{ __('Inventaris') }}
                    </x-responsive-nav-link>
                    {{-- ------------------------------------------------------------- --}}
                    <x-responsive-nav-link :href="route('admin.borrowings.index')" :active="request()->routeIs('admin.borrowings.*')">
                        <i class="fas fa-handshake mr-2"></i> {{ __('Monitoring Peminjaman') }}
                    </x-responsive-nav-link>
                    <x-responsive-nav-link :href="route('admin.reports.daily')" :active="request()->routeIs('admin.reports.daily')">
                        <i class="fas fa-chart-line mr-2"></i> {{ __('Laporan Harian') }}
                    </x-responsive-nav-link>
                @else
                    <x-responsive-nav-link :href="route('user.dashboard')" :active="request()->routeIs('user.dashboard')">
                        <i class="fas fa-home mr-2"></i> {{ __('User Dashboard') }}
                    </x-responsive-nav-link>
                    <x-responsive-nav-link :href="route('user.items.index')" :active="request()->routeIs('user.items.*')">
                        <i class="fas fa-list-alt mr-2"></i> {{ __('Daftar Barang') }}
                    </x-responsive-nav-link>
                    <x-responsive-nav-link :href="route('user.borrowings.create')" :active="request()->routeIs('user.borrowings.create')">
                        <i class="fas fa-plus-circle mr-2"></i> {{ __('Ajukan Peminjaman') }}
                    </x-responsive-nav-link>
                    <x-responsive-nav-link :href="route('user.my-borrowings.index')" :active="request()->routeIs('user.my-borrowings.*')">
                        <i class="fas fa-history mr-2"></i> {{ __('Peminjaman Saya') }}
                    </x-responsive-nav-link>
                @endif
            @endauth
        </div>

        <div class="pt-4 pb-1 border-t border-gray-200 dark:border-gray-700">
            @auth
                <div class="px-4">
                    <div class="font-medium text-base text-gray-800 dark:text-gray-200">{{ Auth::user()->name }}</div>
                    <div class="font-medium text-sm text-gray-500 dark:text-gray-400">{{ Auth::user()->email }}</div>
                </div>

                <div class="mt-3 space-y-1">
                    <x-responsive-nav-link :href="route('profile.edit')">
                        <i class="fas fa-user-circle mr-2"></i> {{ __('Profil') }}
                    </x-responsive-nav-link>

                    <form method="POST" action="{{ route('logout') }}">
                        @csrf
                        <x-responsive-nav-link :href="route('logout')"
                                onclick="event.preventDefault();
                                            this.closest('form').submit();">
                            <i class="fas fa-sign-out-alt mr-2"></i> {{ __('Log Out') }}
                        </x-responsive-nav-link>
                    </form>
                </div>
            @endauth
        </div>
    </div>
</nav>