<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}" class="dark">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="{{ csrf_token() }}">

    <title>Peminjaman Berhasil - {{ config('app.name', 'Laravel') }}</title>

    <link rel="preconnect" href="https://fonts.bunny.net">
    <link href="https://fonts.bunny.net/css?family=figtree:400,500,600&display=swap" rel="stylesheet" />
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
    <script src="https://cdn.tailwindcss.com"></script>
    <script defer src="https://cdn.jsdelivr.net/npm/alpinejs@3.x.x/dist/cdn.min.js"></script>
    <script>
        tailwind.config = {
            darkMode: 'class',
            theme: {
                extend: {
                    colors: {
                        laravel: '#ef3b2d',
                    }
                }
            }
        }
    </script>
</head>
<body class="font-sans antialiased bg-gray-100 dark:bg-gray-900 flex items-center justify-center min-h-screen p-4 sm:p-0">
    <div class="w-full max-w-lg bg-white dark:bg-gray-800 shadow-xl rounded-xl p-6 lg:p-8 border border-gray-200 dark:border-gray-700 text-center">
        <div class="flex flex-col items-center justify-center mb-8">
            <img src="{{ asset('images/logo_jurusan_tjkt.png') }}" alt="Logo Jurusan TJKT" class="h-20 w-auto mb-4 object-contain">
            <h2 class="text-3xl font-extrabold text-green-600 dark:text-green-400 mb-2">
                <i class="fas fa-check-circle mr-2"></i> Pengajuan Berhasil!
            </h2>
            <p class="text-gray-600 dark:text-gray-400 text-base mt-2">
                Permintaan peminjaman Anda telah berhasil diajukan dan sedang menunggu persetujuan admin.
            </p>
        </div>

        <div class="text-left mb-8 space-y-4">
            <h3 class="text-xl font-bold text-gray-900 dark:text-gray-100 mb-4 border-b pb-2 border-gray-200 dark:border-gray-700">Detail Peminjaman Anda:</h3>

            <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                <div>
                    <p class="text-sm font-semibold text-gray-600 dark:text-gray-300">Peminjam:</p>
                    <p class="text-lg font-medium text-gray-900 dark:text-gray-100">
                        @if($borrowing->user)
                            {{ $borrowing->user->name }}
                        @else
                            {{ $borrowing->guest_name }} ({{ $borrowing->guest_class }})
                        @endif
                    </p>
                </div>
                <div>
                    <p class="text-sm font-semibold text-gray-600 dark:text-gray-300">Barang Dipinjam:</p>
                    <p class="text-lg font-medium text-gray-900 dark:text-gray-100">
                        @if($borrowing->item->code == 'BARANG-LAIN')
                            {{ $borrowing->notes }} (Barang Lain)
                        @else
                            {{ $borrowing->item->name }}
                        @endif
                    </p>
                </div>
                <div>
                    <p class="text-sm font-semibold text-gray-600 dark:text-gray-300">Jumlah:</p>
                    <p class="text-lg font-medium text-gray-900 dark:text-gray-100">{{ $borrowing->quantity }}</p>
                </div>
                <div>
                    <p class="text-sm font-semibold text-gray-600 dark:text-gray-300">Tanggal & Jam Pinjam:</p>
                    <p class="text-lg font-medium text-gray-900 dark:text-gray-100">
                        {{ \Carbon\Carbon::parse($borrowing->borrow_date . ' ' . $borrowing->borrow_time)->format('d M Y, H:i') }} WIB
                    </p>
                </div>
                <div class="col-span-1 md:col-span-2">
                    <p class="text-sm font-semibold text-gray-600 dark:text-gray-300">Catatan:</p>
                    <p class="text-lg font-medium text-gray-900 dark:text-gray-100">{{ $borrowing->notes ?? '-' }}</p>
                </div>
                <div class="col-span-1 md:col-span-2">
                    <p class="text-sm font-semibold text-gray-600 dark:text-gray-300">Status:</p>
                    <span class="px-3 py-1 inline-flex text-base leading-5 font-semibold rounded-full bg-yellow-100 text-yellow-800 dark:bg-yellow-700 dark:text-yellow-100">
                        {{ ucfirst($borrowing->status) }}
                    </span>
                </div>
            </div>
        </div>

        <div class="flex flex-col sm:flex-row justify-center gap-4">
            @auth
            <a href="{{ route('user.my-borrowings.index') }}" class="inline-flex items-center px-6 py-3 bg-gray-200 dark:bg-gray-700 border border-transparent rounded-lg font-semibold text-sm text-gray-800 dark:text-gray-200 uppercase tracking-wider hover:bg-gray-300 dark:hover:bg-gray-600 focus:bg-gray-300 dark:focus:bg-gray-600 active:bg-gray-400 dark:active:bg-gray-500 focus:outline-none focus:ring-2 focus:ring-indigo-500 focus:ring-offset-2 dark:focus:ring-offset-gray-800 transition ease-in-out duration-150 shadow-sm">
                <i class="fas fa-list-alt mr-2"></i> {{ __('Lihat Riwayat Peminjaman Saya') }}
            </a>
            @else
            <a href="{{ route('guest.borrow.create') }}" class="inline-flex items-center px-6 py-3 bg-gray-200 dark:bg-gray-700 border border-transparent rounded-lg font-semibold text-sm text-gray-800 dark:text-gray-200 uppercase tracking-wider hover:bg-gray-300 dark:hover:bg-gray-600 focus:bg-gray-300 dark:focus:bg-gray-600 active:bg-gray-400 dark:active:bg-gray-500 focus:outline-none focus:ring-2 focus:ring-indigo-500 focus:ring-offset-2 dark:focus:ring-offset-gray-800 transition ease-in-out duration-150 shadow-sm">
                <i class="fas fa-plus-circle mr-2"></i> {{ __('Ajukan Peminjaman Lain') }}
            </a>
            <a href="{{ route('login') }}" class="inline-flex items-center px-6 py-3 bg-blue-600 border border-transparent rounded-lg font-semibold text-sm text-white uppercase tracking-wider hover:bg-blue-700 focus:bg-blue-700 active:bg-blue-900 focus:outline-none focus:ring-2 focus:ring-indigo-500 focus:ring-offset-2 dark:focus:ring-offset-gray-800 transition ease-in-out duration-150 shadow-sm">
                <i class="fas fa-sign-in-alt mr-2"></i> {{ __('Login sebagai Pengguna') }}
            </a>
            @endauth
        </div>
    </div>
</body>
</html>