<x-guest-layout>
    <div class="w-full max-w-md bg-white dark:bg-gray-800 shadow-xl rounded-xl p-6 lg:p-8 border border-gray-200 dark:border-gray-700"> {{-- Kontainer utama --}}
        <div class="flex flex-col items-center justify-center mb-8"> {{-- Header dengan logo dan judul --}}
            {{-- Ganti dengan logo jurusan Anda --}}
            {{-- Pastikan gambar logo ini ada di public/images/logo_jurusan_tjkt.png --}}
            <img src="{{ asset('images/logo_jurusan_tjkt.png') }}" alt="Logo Jurusan TJKT" class="h-20 w-auto mb-4 object-contain">
            <h2 class="text-3xl font-extrabold text-gray-900 dark:text-white text-center">Selamat Datang di Lab TJKT</h2>
            <p class="text-gray-600 dark:text-gray-400 text-base mt-2 text-center">Silakan masuk untuk melanjutkan.</p>
        </div>

        @if (session('status'))
            <div class="bg-blue-100 dark:bg-blue-800 border border-blue-400 text-blue-700 dark:text-blue-200 px-4 py-3 rounded relative mb-6 shadow-md" role="alert">
                <span class="block sm:inline font-bold"><i class="fas fa-info-circle mr-2"></i> Info:</span>
                <span class="block sm:inline">{{ session('status') }}</span>
            </div>
        @endif

        <form method="POST" action="{{ route('login') }}">
            @csrf

            <div class="mb-5"> {{-- Margin bawah ditingkatkan --}}
                <x-input-label for="email" :value="__('Email')" />
                <x-text-input id="email" class="block mt-1 w-full p-3 text-base rounded-md border-gray-300 dark:border-gray-600 shadow-sm focus:border-indigo-500 focus:ring-indigo-500 dark:bg-gray-700 dark:text-white transition-colors duration-200" type="email" name="email" :value="old('email')" required autofocus autocomplete="username" />
                <x-input-error :messages="$errors->get('email')" class="mt-2" />
            </div>

            <div class="mb-5"> {{-- Margin bawah ditingkatkan --}}
                <x-input-label for="password" :value="__('Password')" />

                <x-text-input id="password" class="block mt-1 w-full p-3 text-base rounded-md border-gray-300 dark:border-gray-600 shadow-sm focus:border-indigo-500 focus:ring-indigo-500 dark:bg-gray-700 dark:text-white transition-colors duration-200"
                                type="password"
                                name="password"
                                required autocomplete="current-password" />

                <x-input-error :messages="$errors->get('password')" class="mt-2" />
            </div>

            <div class="block mt-4 mb-6"> {{-- Margin bawah ditingkatkan --}}
                <label for="remember_me" class="inline-flex items-center">
                    <input id="remember_me" type="checkbox" class="rounded dark:bg-gray-900 border-gray-300 dark:border-gray-700 text-indigo-600 shadow-sm focus:ring-indigo-500 dark:focus:ring-indigo-600 dark:focus:ring-offset-gray-800" name="remember">
                    <span class="ms-2 text-sm text-gray-600 dark:text-gray-400">{{ __('Remember me') }}</span>
                </label>
            </div>

            <div class="flex flex-col sm:flex-row items-center justify-between gap-4 mt-6"> {{-- Layout tombol responsif --}}
                {{-- Tombol Peminjaman Tamu --}}
                <a href="{{ route('guest.borrow.create') }}" class="w-full sm:w-auto inline-flex items-center justify-center px-6 py-3 bg-gray-600 dark:bg-gray-400 border border-transparent rounded-lg font-semibold text-sm text-white dark:text-gray-900 uppercase tracking-wider shadow-md hover:bg-gray-700 dark:hover:bg-gray-300 focus:bg-gray-700 dark:focus:bg-gray-300 active:bg-gray-900 dark:active:bg-gray-500 focus:outline-none focus:ring-2 focus:ring-indigo-500 focus:ring-offset-2 dark:focus:ring-offset-gray-800 transition ease-in-out duration-150">
                    <i class="fas fa-user-friends mr-2"></i> {{ __('Peminjaman Tamu') }}
                </a>

                <div class="flex flex-col sm:flex-row items-center justify-end w-full sm:w-auto gap-4">
                    {{-- Tombol Register --}}
                    @if (Route::has('register'))
                        <a href="{{ route('register') }}" class="w-full sm:w-auto inline-flex items-center justify-center px-6 py-3 bg-gray-200 dark:bg-gray-700 border border-transparent rounded-lg font-semibold text-sm text-gray-800 dark:text-gray-200 uppercase tracking-wider shadow-md hover:bg-gray-300 dark:hover:bg-gray-600 focus:bg-gray-300 dark:focus:bg-gray-600 active:bg-gray-400 dark:active:bg-gray-500 focus:outline-none focus:ring-2 focus:ring-indigo-500 focus:ring-offset-2 dark:focus:ring-offset-gray-800 transition ease-in-out duration-150">
                            {{ __('Register') }}
                        </a>
                    @endif

                    {{-- Link Forgot Password --}}
                    @if (Route::has('password.request'))
                        <a class="underline text-sm text-gray-600 dark:text-gray-400 hover:text-gray-900 dark:hover:text-gray-100 rounded-md focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500 dark:focus:ring-offset-gray-800" href="{{ route('password.request') }}">
                            {{ __('Forgot password?') }}
                        </a>
                    @endif

                    {{-- Tombol Log In --}}
                    <x-primary-button class="px-6 py-3 shadow-md w-full sm:w-auto"> {{-- Menghapus Alpine.js isSubmitting --}}
                        <i class="fas fa-sign-in-alt mr-2"></i> {{ __('Log in') }}
                    </x-primary-button>
                </div>
            </div>
        </form>
    </div>
</x-guest-layout>