<x-app-layout>
    <x-slot name="header">
        <h2 class="font-bold text-3xl text-gray-800 dark:text-gray-100 leading-tight">
            {{ __('Edit Barang: ') . $item->name }}
            </h2>
        </x-slot>

        <div class="py-8 lg:py-12 bg-gray-100 dark:bg-gray-900 min-h-screen">
            {{-- DIUBAH: w-full untuk lebar penuh, px-4 sm:px-6 lg:px-8 untuk padding --}}
            <div class="w-full px-4 sm:px-6 lg:px-8">
                <div class="bg-white dark:bg-gray-800 overflow-hidden shadow-2xl sm:rounded-xl p-6 lg:p-8 border border-gray-200 dark:border-gray-700">
                    <h3 class="text-2xl font-extrabold text-gray-900 dark:text-gray-100 mb-6 border-b pb-4 border-gray-200 dark:border-gray-700">{{ __('Formulir Edit Barang') }}</h3>
                    <form method="POST" action="{{ route('admin.items.update', $item) }}">
                        @csrf
                        @method('PUT') {{-- Penting untuk metode UPDATE --}}

                        <div class="mb-5">
                            <x-input-label for="name" :value="__('Nama Barang')" />
                            <x-text-input id="name" class="block mt-1 w-full p-3 text-base" type="text" name="name" :value="old('name', $item->name)" required autofocus placeholder="Contoh: Kabel UTP Cat6" />
                            <x-input-error :messages="$errors->get('name')" class="mt-2" />
                        </div>

                        <div class="mb-5">
                            <x-input-label for="code" :value="__('Kode Barang')" />
                            <x-text-input id="code" class="block mt-1 w-full p-3 text-base" type="text" name="code" :value="old('code', $item->code)" required placeholder="Contoh: KB-UTP-001" />
                            <x-input-error :messages="$errors->get('code')" class="mt-2" />
                        </div>

                        <div class="mb-5">
                            <x-input-label for="description" :value="__('Deskripsi (Opsional)')" />
                            <textarea id="description" name="description" class="block mt-1 w-full p-3 text-base border-gray-300 dark:border-gray-700 dark:bg-gray-900 dark:text-gray-300 focus:border-indigo-500 focus:ring-indigo-500 dark:focus:ring-indigo-600 focus:ring-indigo-500 dark:focus:ring-indigo-600 rounded-md shadow-sm" rows="4" placeholder="Contoh: Kabel UTP jenis Cat6 dengan panjang 1 meter, digunakan untuk koneksi jaringan." style="resize: vertical;">{{ old('description', $item->description) }}</textarea>
                            <x-input-error :messages="$errors->get('description')" class="mt-2" />
                        </div>

                        <div class="mb-5">
                            <x-input-label for="quantity" :value="__('Jumlah / Stok')" />
                            <x-text-input id="quantity" class="block mt-1 w-full p-3 text-base" type="number" name="quantity" :value="old('quantity', $item->quantity)" required min="0" placeholder="Contoh: 100" />
                            <x-input-error :messages="$errors->get('quantity')" class="mt-2" />
                        </div>

                        <div class="mb-7">
                            <x-input-label for="status" :value="__('Status')" />
                            <select id="status" name="status" class="block w-full mt-1 p-3 text-base border-gray-300 dark:border-gray-700 dark:bg-gray-900 dark:text-gray-300 focus:border-indigo-500 focus:ring-indigo-500 dark:focus:ring-indigo-600 dark:focus:ring-indigo-600 rounded-md shadow-sm" required>
                                <option value="available" @selected(old('status', $item->status) == 'available')>Tersedia (Available)</option>
                                <option value="broken" @selected(old('status', $item->status) == 'broken')>Rusak (Broken)</option>
                                <option value="maintenance" @selected(old('status', $item->status) == 'maintenance')>Perbaikan (Maintenance)</option>
                            </select>
                            <x-input-error :messages="$errors->get('status')" class="mt-2" />
                        </div>

                        <div class="flex items-center justify-end">
                            <a href="{{ route('admin.items.index') }}" class="inline-flex items-center px-6 py-3 bg-gray-200 dark:bg-gray-700 border border-transparent rounded-lg font-semibold text-sm text-gray-800 dark:text-gray-200 uppercase tracking-wider hover:bg-gray-300 dark:hover:bg-gray-600 focus:bg-gray-300 dark:focus:bg-gray-600 active:bg-gray-400 dark:active:bg-gray-500 focus:outline-none focus:ring-2 focus:ring-indigo-500 focus:ring-offset-2 dark:focus:ring-offset-gray-800 transition ease-in-out duration-150 mr-3 shadow-sm">
                                <i class="fas fa-times-circle mr-2"></i> {{ __('Batal') }}
                            </a>
                            <x-primary-button class="ms-0 px-6 py-3 shadow-md">
                                <i class="fas fa-save mr-2"></i> {{ __('Update Barang') }}
                            </x-primary-button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </x-app-layout>
    ```
---

### **5. `resources/views/admin/items/show.blade.php`**

```blade
<x-app-layout>
    <x-slot name="header">
        <h2 class="font-bold text-3xl text-gray-800 dark:text-gray-100 leading-tight">
            {{ __('Detail Barang: ') . $item->name }}
        </h2>
    </x-slot>

    <div class="py-8 lg:py-12 bg-gray-100 dark:bg-gray-900 min-h-screen">
        {{-- DIUBAH: w-full untuk lebar penuh, px-4 sm:px-6 lg:px-8 untuk padding --}}
        <div class="w-full px-4 sm:px-6 lg:px-8">
            <div class="bg-white dark:bg-gray-800 overflow-hidden shadow-2xl sm:rounded-xl p-6 lg:p-8 border border-gray-200 dark:border-gray-700">
                <h3 class="text-2xl font-extrabold text-gray-900 dark:text-gray-100 mb-6 border-b pb-4 border-gray-200 dark:border-gray-700">{{ __('Informasi Detail Barang') }}</h3>
                <div class="space-y-5">
                    <div>
                        <p class="text-sm font-semibold text-gray-600 dark:text-gray-300">{{ __('Nama Barang') }}:</p>
                        <p class="text-xl font-bold text-gray-900 dark:text-gray-100 mt-1">{{ $item->name }}</p>
                    </div>

                    <div>
                        <p class="text-sm font-semibold text-gray-600 dark:text-gray-300">{{ __('Kode Barang') }}:</p>
                        <p class="text-lg font-medium text-gray-900 dark:text-gray-100 mt-1">{{ $item->code }}</p>
                    </div>

                    <div>
                        <p class="text-sm font-semibold text-gray-600 dark:text-gray-300">{{ __('Deskripsi') }}:</p>
                        <p class="text-gray-800 dark:text-gray-200 mt-1">{{ $item->description ?? '-' }}</p>
                    </div>

                    <div>
                        <p class="text-sm font-semibold text-gray-600 dark:text-gray-300">{{ __('Jumlah / Stok') }}:</p>
                        <p class="text-gray-800 dark:text-gray-200 mt-1">{{ $item->quantity }}</p>
                    </div>

                    <div>
                        <p class="text-sm font-semibold text-gray-600 dark:text-gray-300">{{ __('Status') }}:</p>
                        <span class="px-3 py-1 inline-flex text-sm leading-5 font-semibold rounded-full mt-1
                            @if ($item->status == 'available') bg-green-100 text-green-800 dark:bg-green-700 dark:text-green-100
                            @elseif ($item->status == 'broken') bg-red-100 text-red-800 dark:bg-red-700 dark:text-red-100
                            @elseif ($item->status == 'maintenance') bg-yellow-100 text-yellow-800 dark:bg-yellow-700 dark:text-yellow-100
                            @else bg-gray-100 text-gray-800 dark:bg-gray-600 dark:text-gray-200 @endif">
                            {{ ucfirst($item->status) }}
                        </span>
                    </div>

                    <div>
                        <p class="text-sm font-semibold text-gray-600 dark:text-gray-300">{{ __('Dibuat Pada') }}:</p>
                        <p class="text-gray-800 dark:text-gray-200 mt-1">{{ $item->created_at->format('d M Y H:i') }}</p>
                    </div>

                    <div>
                        <p class="text-sm font-semibold text-gray-600 dark:text-gray-300">{{ __('Terakhir Diperbarui') }}:</p>
                        <p class="text-gray-800 dark:text-gray-200 mt-1">{{ $item->updated_at->format('d M Y H:i') }}</p>
                    </div>
                </div>

                <div class="flex justify-end mt-8 pt-4 border-t border-gray-200 dark:border-gray-700">
                    <a href="{{ route('admin.items.index') }}" class="inline-flex items-center px-6 py-3 bg-gray-200 dark:bg-gray-700 border border-transparent rounded-lg font-semibold text-sm text-gray-800 dark:text-gray-200 uppercase tracking-wider hover:bg-gray-300 dark:hover:bg-gray-600 focus:bg-gray-300 dark:focus:bg-gray-600 active:bg-gray-400 dark:active:bg-gray-500 focus:outline-none focus:ring-2 focus:ring-indigo-500 focus:ring-offset-2 dark:focus:ring-offset-gray-800 transition ease-in-out duration-150 mr-3 shadow-sm">
                        <i class="fas fa-arrow-left mr-2"></i> {{ __('Kembali ke Daftar') }}
                    </a>
                    <a href="{{ route('admin.items.edit', $item) }}" class="inline-flex items-center px-6 py-3 bg-indigo-600 border border-transparent rounded-lg font-semibold text-sm text-white uppercase tracking-wider hover:bg-indigo-700 focus:bg-indigo-700 active:bg-indigo-900 focus:outline-none focus:ring-2 focus:ring-indigo-500 focus:ring-offset-2 dark:focus:ring-offset-gray-800 transition ease-in-out duration-150 shadow-md">
                        <i class="fas fa-edit mr-2"></i> {{ __('Edit Barang') }}
                    </a>
                </div>
            </div>
        </div>
    </div>
</x-app-layout>