<x-app-layout>
    <x-slot name="header">
        <h2 class="font-bold text-3xl text-gray-800 dark:text-gray-100 leading-tight">
            {{ __('Tambah Barang Baru') }}
        </h2>
    </x-slot>

    <div class="py-8 lg:py-12 bg-gray-100 dark:bg-gray-900 min-h-screen">
        {{-- DIUBAH: w-full untuk lebar penuh, px-4 sm:px-6 lg:px-8 untuk padding --}}
        <div class="w-full px-4 sm:px-6 lg:px-8">
            <div class="bg-white dark:bg-gray-800 overflow-hidden shadow-2xl sm:rounded-xl p-6 lg:p-8 border border-gray-200 dark:border-gray-700">
                <h3 class="text-2xl font-extrabold text-gray-900 dark:text-gray-100 mb-6 border-b pb-4 border-gray-200 dark:border-gray-700">{{ __('Formulir Penambahan Barang') }}</h3>
                <form method="POST" action="{{ route('admin.items.store') }}">
                    @csrf

                    <div class="mb-5">
                        <x-input-label for="name" :value="__('Nama Barang')" />
                        <x-text-input id="name" class="block mt-1 w-full p-3 text-base" type="text" name="name" :value="old('name')" required autofocus placeholder="Contoh: Kabel UTP Cat6" />
                        <x-input-error :messages="$errors->get('name')" class="mt-2" />
                    </div>

                    <div class="mb-5">
                        <x-input-label for="code" :value="__('Kode Barang')" />
                        <x-text-input id="code" class="block mt-1 w-full p-3 text-base" type="text" name="code" :value="old('code')" required placeholder="Contoh: KB-UTP-001" />
                        <x-input-error :messages="$errors->get('code')" class="mt-2" />
                    </div>

                    <div class="mb-5">
                        <x-input-label for="description" :value="__('Deskripsi (Opsional)')" />
                        <textarea id="description" name="description" class="block mt-1 w-full p-3 text-base border-gray-300 dark:border-gray-700 dark:bg-gray-900 dark:text-gray-300 focus:border-indigo-500 focus:ring-indigo-500 dark:focus:ring-indigo-600 focus:ring-indigo-500 dark:focus:ring-indigo-600 rounded-md shadow-sm" rows="4" placeholder="Contoh: Kabel UTP jenis Cat6 dengan panjang 1 meter, digunakan untuk koneksi jaringan." style="resize: vertical;">{{ old('description') }}</textarea>
                        <x-input-error :messages="$errors->get('description')" class="mt-2" />
                    </div>

                    <div class="mb-5">
                        <x-input-label for="quantity" :value="__('Jumlah / Stok')" />
                        <x-text-input id="quantity" class="block mt-1 w-full p-3 text-base" type="number" name="quantity" :value="old('quantity')" required min="0" placeholder="Contoh: 100" />
                        <x-input-error :messages="$errors->get('quantity')" class="mt-2" />
                    </div>

                    <div class="mb-7">
                        <x-input-label for="status" :value="__('Status')" />
                        <select id="status" name="status" class="block w-full mt-1 p-3 text-base border-gray-300 dark:border-gray-700 dark:bg-gray-900 dark:text-gray-300 focus:border-indigo-500 focus:ring-indigo-500 dark:focus:ring-indigo-600 dark:focus:ring-indigo-600 rounded-md shadow-sm" required>
                            <option value="available" @selected(old('status') == 'available')>Tersedia (Available)</option>
                            <option value="broken" @selected(old('status') == 'broken')>Rusak (Broken)</option>
                            <option value="maintenance" @selected(old('status') == 'maintenance')>Perbaikan (Maintenance)</option>
                        </select>
                        <x-input-error :messages="$errors->get('status')" class="mt-2" />
                    </div>

                    <div class="flex items-center justify-end">
                        <a href="{{ route('admin.items.index') }}" class="inline-flex items-center px-6 py-3 bg-gray-200 dark:bg-gray-700 border border-transparent rounded-lg font-semibold text-sm text-gray-800 dark:text-gray-200 uppercase tracking-wider hover:bg-gray-300 dark:hover:bg-gray-600 focus:bg-gray-300 dark:focus:bg-gray-600 active:bg-gray-400 dark:active:bg-gray-500 focus:outline-none focus:ring-2 focus:ring-indigo-500 focus:ring-offset-2 dark:focus:ring-offset-gray-800 transition ease-in-out duration-150 mr-3 shadow-sm">
                            <i class="fas fa-times-circle mr-2"></i> {{ __('Batal') }}
                        </a>
                        <x-primary-button class="ms-0 px-6 py-3 shadow-md">
                            <i class="fas fa-save mr-2"></i> {{ __('Simpan Barang') }}
                        </x-primary-button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</x-app-layout>