<x-app-layout>
    <x-slot name="header">
        <h2 class="font-bold text-3xl text-gray-800 dark:text-gray-100 leading-tight">
            {{ __('Admin Dashboard') }}
        </h2>
    </x-slot>

    <div class="py-8 lg:py-12 bg-gray-100 dark:bg-gray-900 min-h-screen">
        <div class="w-full px-4 sm:px-6 lg:px-8">
            <div class="bg-white dark:bg-gray-800 overflow-hidden shadow-2xl sm:rounded-xl p-6 lg:p-8 border border-gray-200 dark:border-gray-700">
                <h3 class="text-2xl font-extrabold text-gray-900 dark:text-gray-100 mb-8 border-b pb-4 border-gray-200 dark:border-gray-700">Statistik Utama</h3>

                <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-6 mb-12">
                    {{-- Card Total Pengguna --}}
                    <div class="bg-gradient-to-br from-indigo-600 to-indigo-800 dark:from-indigo-800 dark:to-indigo-950 text-white p-6 rounded-xl shadow-lg flex items-center space-x-4 transform transition duration-300 hover:scale-105 hover:shadow-xl">
                        <div class="p-4 bg-indigo-900 dark:bg-indigo-700 rounded-full flex-shrink-0">
                            <i class="fas fa-users text-3xl"></i>
                        </div>
                        <div>
                            <p class="text-sm font-light opacity-90 mb-1">{{ __('Total Pengguna') }}</p>
                            <p class="text-5xl font-extrabold">{{ $totalUsers }}</p>
                        </div>
                    </div>

                    {{-- Card Total Barang --}}
                    <div class="bg-gradient-to-br from-teal-600 to-teal-800 dark:from-teal-800 dark:to-teal-950 text-white p-6 rounded-xl shadow-lg flex items-center space-x-4 transform transition duration-300 hover:scale-105 hover:shadow-xl">
                        <div class="p-4 bg-teal-900 dark:bg-teal-700 rounded-full flex-shrink-0">
                            <i class="fas fa-boxes text-3xl"></i>
                        </div>
                        <div>
                            <p class="text-sm font-light opacity-90 mb-1">{{ __('Total Barang') }}</p>
                            <p class="text-5xl font-extrabold">{{ $totalItems }}</p>
                        </div>
                    </div>

                    {{-- Card Peminjaman Tertunda --}}
                    <div id="pending-borrowings-card" class="bg-gradient-to-br from-amber-600 to-amber-800 dark:from-amber-800 dark:to-amber-950 text-white p-6 rounded-xl shadow-lg flex items-center space-x-4 transform transition duration-300 hover:scale-105 hover:shadow-xl">
                        <div class="p-4 bg-amber-900 dark:bg-amber-700 rounded-full flex-shrink-0">
                            <i class="fas fa-hourglass-half text-3xl"></i>
                        </div>
                        <div>
                            <p class="text-sm font-light opacity-90 mb-1">{{ __('Peminjaman Tertunda') }}</p>
                            <p id="pending-borrowings-count" class="text-5xl font-extrabold">{{ $pendingBorrowings }}</p>
                        </div>
                    </div>

                    {{-- Card Peminjaman Disetujui --}}
                    <div class="bg-gradient-to-br from-green-600 to-green-800 dark:from-green-800 dark:to-green-950 text-white p-6 rounded-xl shadow-lg flex items-center space-x-4 transform transition duration-300 hover:scale-105 hover:shadow-xl">
                        <div class="p-4 bg-green-900 dark:bg-green-700 rounded-full flex-shrink-0">
                            <i class="fas fa-check-circle text-3xl"></i>
                        </div>
                        <div>
                            <p class="text-sm font-light opacity-90 mb-1">{{ __('Peminjaman Disetujui') }}</p>
                            <p class="text-5xl font-extrabold">{{ $approvedBorrowings }}</p>
                        </div>
                    </div>
                </div>

                <h3 class="text-2xl font-extrabold text-gray-900 dark:text-gray-100 mb-6 border-b pb-4 border-gray-200 dark:border-gray-700">Aksi Cepat</h3>
                {{-- DIUBAH: lg:grid-cols-4 untuk 4 kolom di layar lebar --}}
                <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6">
                    <a href="{{ route('admin.items.index') }}" class="group flex items-center p-6 bg-gray-50 dark:bg-gray-700 rounded-xl shadow-md hover:shadow-lg transition-all duration-300 transform hover:-translate-y-2 border border-gray-200 dark:border-gray-600">
                        <div class="p-4 bg-indigo-500 dark:bg-indigo-600 text-white rounded-full mr-4 group-hover:bg-indigo-700 dark:group-hover:bg-indigo-800 transition-colors">
                            <i class="fas fa-tools text-2xl"></i>
                        </div>
                        <div>
                            <p class="text-xl font-bold text-gray-800 dark:text-gray-100 group-hover:text-indigo-700 dark:group-hover:text-indigo-200 transition-colors">{{ __('Kelola Barang') }}</p>
                            <p class="text-sm text-gray-600 dark:text-gray-300 mt-1">Tambah, edit, hapus, dan lihat inventaris barang lab.</p>
                        </div>
                    </a>

                    <a href="{{ route('admin.inventories.index') }}" class="group flex items-center p-6 bg-gray-50 dark:bg-gray-700 rounded-xl shadow-md hover:shadow-lg transition-all duration-300 transform hover:-translate-y-2 border border-gray-200 dark:border-gray-600">
                        <div class="p-4 bg-purple-500 dark:bg-purple-600 text-white rounded-full mr-4 group-hover:bg-purple-700 dark:group-hover:bg-purple-800 transition-colors">
                            <i class="fas fa-warehouse text-2xl"></i>
                        </div>
                        <div>
                            <p class="text-xl font-bold text-gray-800 dark:text-gray-100 group-hover:text-purple-700 dark:group-hover:text-purple-200 transition-colors">{{ __('Kelola Inventaris') }}</p>
                            <p class="text-sm text-gray-600 dark:text-gray-300 mt-1">Kelola aset fisik, furnitur, dan peralatan lab lainnya.</p>
                        </div>
                    </a>

                    <a href="{{ route('admin.borrowings.index') }}" class="group flex items-center p-6 bg-gray-50 dark:bg-gray-700 rounded-xl shadow-md hover:shadow-lg transition-all duration-300 transform hover:-translate-y-2 border border-gray-200 dark:border-gray-600">
                        <div class="p-4 bg-teal-500 dark:bg-teal-600 text-white rounded-full mr-4 group-hover:bg-teal-700 dark:group-hover:bg-teal-800 transition-colors">
                            <i class="fas fa-calendar-check text-2xl"></i>
                        </div>
                        <div>
                            <p class="text-xl font-bold text-gray-800 dark:text-gray-100 group-hover:text-teal-700 dark:group-hover:text-teal-200 transition-colors">{{ __('Monitoring Peminjaman') }}</p>
                            <p class="text-sm text-gray-600 dark:text-gray-300 mt-1">Setujui, tolak, dan kelola semua permintaan peminjaman.</p>
                        </div>
                    </a>

                    <a href="{{ route('admin.reports.daily') }}" class="group flex items-center p-6 bg-gray-50 dark:bg-gray-700 rounded-xl shadow-md hover:shadow-lg transition-all duration-300 transform hover:-translate-y-2 border border-gray-200 dark:border-gray-600">
                        <div class="p-4 bg-red-500 dark:bg-red-600 text-white rounded-full mr-4 group-hover:bg-red-700 dark:group-hover:bg-red-800 transition-colors">
                            <i class="fas fa-chart-line text-2xl"></i>
                        </div>
                        <div>
                            <p class="text-xl font-bold text-gray-800 dark:text-gray-100 group-hover:text-red-700 dark:group-hover:text-red-200 transition-colors">{{ __('Laporan & Analisis') }}</p>
                            <p class="text-sm text-gray-600 dark:text-gray-300 mt-1">Lihat ringkasan aktivitas dan laporan harian.</p>
                        </div>
                    </a>
                </div>
            </div>
        </div>
    </div>

    {{-- Script JavaScript untuk AJAX Polling --}}
    <script>
        document.addEventListener('DOMContentLoaded', function () {
            const pendingCountElement = document.getElementById('pending-borrowings-count');
            const pendingCard = document.getElementById('pending-borrowings-card');
            let currentPendingCount = parseInt(pendingCountElement.innerText);

            setInterval(async () => {
                try {
                    const response = await fetch('{{ route('admin.dashboard.pending-requests-count') }}');
                    const data = await response.json();
                    const newPendingCount = data.pending_count;

                    if (newPendingCount !== currentPendingCount) {
                        // Update the number
                        pendingCountElement.innerText = newPendingCount;

                        // Add a subtle animation/highlight if count increased
                        if (newPendingCount > currentPendingCount) {
                            pendingCard.classList.add('animate-pulse'); // Add pulse effect
                            setTimeout(() => {
                                pendingCard.classList.remove('animate-pulse'); // Remove after a short delay
                            }, 1000); // 1 second
                        }
                        currentPendingCount = newPendingCount;
                    }
                } catch (error) {
                    console.error('Error fetching pending requests count:', error);
                }
            }, 3000); // Poll every 3 seconds (3000 milliseconds)
        });
    </script>
</x-app-layout>