<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;
use App\Models\User; // Pastikan ini ada
use App\Models\Item; // Diperlukan jika Anda menyertakan item seeding inline

class DatabaseSeeder extends Seeder
{
    /**
     * Seed the application's database.
     */
    public function run(): void
    {
        // Menonaktifkan pengecekan foreign key constraints sementara
        DB::statement('SET FOREIGN_KEY_CHECKS=0;');

        // Hapus data dari tabel yang memiliki foreign key terlebih dahulu
        DB::table('borrowings')->truncate();
        // DB::table('items')->truncate(); // BARIS INI DIKOMENTARI/DIHAPUS
        DB::table('users')->truncate();


        // Mengaktifkan kembali pengecekan foreign key constraints
        DB::statement('SET FOREIGN_KEY_CHECKS=1;');

        // Akun Admin
        DB::table('users')->insert([
            'name' => 'Admin Lab TJKT',
            'email' => 'admin@labtjkt.com',
            'password' => Hash::make('password'), // Password default: password
            'role' => 'admin', // Role admin
            'email_verified_at' => now(),
            'created_at' => now(),
            'updated_at' => now(),
        ]);

        // Akun User Biasa
        DB::table('users')->insert([
            'name' => 'User Peminjam',
            'email' => 'user@peminjam.com',
            'password' => Hash::make('password'), // Password default: password
            'role' => 'user', // Role user biasa
            'email_verified_at' => now(),
            'created_at' => now(),
            'updated_at' => now(),
        ]);

        // Item default yang sebelumnya saya tambahkan agar ada di database
        // Ini diperlukan agar dropdown tidak kosong setelah rollback
        DB::table('items')->insert([
            ['name' => 'Laptop', 'code' => 'LAPTOP-001', 'quantity' => 15, 'description' => 'Laptop untuk keperluan praktikum.', 'status' => 'available', 'created_at' => now(), 'updated_at' => now()],
            ['name' => 'Projector', 'code' => 'PROJ-001', 'quantity' => 5, 'description' => 'Projector untuk presentasi.', 'status' => 'available', 'created_at' => now(), 'updated_at' => now()],
            ['name' => 'Router Cisco', 'code' => 'RTR-CSCO-001', 'quantity' => 8, 'description' => 'Router merek Cisco untuk simulasi jaringan.', 'status' => 'available', 'created_at' => now(), 'updated_at' => now()],
            ['name' => 'Kabel UTP', 'code' => 'KBL-UTP-001', 'quantity' => 50, 'description' => 'Kabel jaringan UTP Cat5e.', 'status' => 'available', 'created_at' => now(), 'updated_at' => now()],
            ['name' => 'Tang Crimping', 'code' => 'TANG-CRMP-001', 'quantity' => 12, 'description' => 'Alat untuk mengkrimping kabel jaringan.', 'status' => 'available', 'created_at' => now(), 'updated_at' => now()],
        ]);
    }
}