<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('inventories', function (Blueprint $table) {
            $table->id();
            $table->string('name'); // Nama barang inventaris (e.g., Meja Komputer, Kursi, Proyektor)
            $table->string('code')->unique(); // Kode inventaris (e.g., INV-MEJA-001)
            $table->string('serial_number')->nullable()->unique(); // Nomor seri (jika ada dan unik)
            $table->text('description')->nullable(); // Deskripsi detail
            $table->string('location')->nullable(); // Lokasi spesifik (e.g., Ruang Lab 1, Gudang)
            $table->string('condition')->default('Baik'); // Kondisi (e.g., Baik, Rusak Ringan, Rusak Berat, Perlu Perbaikan)
            $table->date('purchase_date')->nullable(); // Tanggal Pembelian
            $table->string('owner')->nullable(); // Kepemilikan (e.g., Sekolah, Jurusan TJKT)
            $table->text('notes')->nullable(); // Catatan tambahan
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('inventories');
    }
};