<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Carbon\Carbon;
use App\Models\Borrowing;
use Maatwebsite\Excel\Facades\Excel; // BARIS INI DITAMBAHKAN
use App\Exports\DailyReportExport;    // BARIS INI DITAMBAHKAN

class ReportController extends Controller
{
    /**
     * Menampilkan laporan harian aktivitas peminjaman.
     */
    public function daily()
    {
        $today = Carbon::today(); // Tanggal hari ini

        // Statistik Ringkasan Harian
        $dailySummary = [
            'new_pending_requests' => Borrowing::whereDate('created_at', $today)
                                                ->where('status', 'pending')
                                                ->count(),
            'approved_today' => Borrowing::whereDate('borrow_date', $today) // Barang yang disetujui untuk dipinjam hari ini
                                        ->where('status', 'approved')
                                        ->count(),
            'returned_today' => Borrowing::whereDate('return_date', $today) // Barang yang dikembalikan hari ini
                                        ->where('status', 'returned')
                                        ->count(),
            'total_active_borrowings' => Borrowing::whereIn('status', ['pending', 'approved', 'overdue'])->count(), // Total peminjaman aktif
        ];

        // Detail Peminjaman Baru Hari Ini (Pending)
        $newPendingBorrowings = Borrowing::with(['user', 'item'])
                                        ->whereDate('created_at', $today)
                                        ->where('status', 'pending')
                                        ->latest()
                                        ->get();

        // Detail Barang Dipinjam Hari Ini (Approved untuk borrow_date hari ini)
        $itemsBorrowedToday = Borrowing::with(['user', 'item'])
                                        ->whereDate('borrow_date', $today)
                                        ->where('status', 'approved')
                                        ->latest()
                                        ->get();

        // Detail Barang Dikembalikan Hari Ini
        $itemsReturnedToday = Borrowing::with(['user', 'item'])
                                        ->whereDate('return_date', $today)
                                        ->where('status', 'returned')
                                        ->latest()
                                        ->get();

        return view('admin.reports.daily', compact(
            'today',
            'dailySummary',
            'newPendingBorrowings',
            'itemsBorrowedToday',
            'itemsReturnedToday'
        ));
    }

    /**
     * Mengekspor laporan harian ke file Excel.
     */
    public function exportDailyReport()
    {
        $today = Carbon::today();
        $fileName = 'Laporan_Peminjaman_Harian_' . $today->format('Y-m-d') . '.xlsx';

        return Excel::download(new DailyReportExport($today), $fileName);
    }
}